//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;

namespace HelloWorldService
{
	public class HelloWorldServiceClass : System.ServiceProcess.ServiceBase
	{
		private System.Timers.Timer timer;
		private System.Diagnostics.PerformanceCounter performanceCounter;
		/// <summary> 
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public HelloWorldServiceClass()
		{
			// To wywoanie jest wymagane przez Windows.Forms Component Designer.
			InitializeComponent();

			// TODO: Dodanie kodu konstruktora po wywoaniu InitializeComponent
		}

		// Gwny punkt wejcia dla procesu
		static void Main()
		{
			System.ServiceProcess.ServiceBase[] ServicesToRun;
	
			// W tym samym procesie moe dziaa kilka usug uytkownika. Aby doda
			// kolejn usug do tego procesu, naley zmieni poniszy wiersz w celu
			// utworzenia drugiego obiektu usugi, na przykad:
			//
			//   ServicesToRun = New System.ServiceProcess.ServiceBase[] {new HelloWorldServiceClass(), new MySecondUserService()};
			//
			ServicesToRun = new System.ServiceProcess.ServiceBase[] { new HelloWorldServiceClass() };

			System.ServiceProcess.ServiceBase.Run(ServicesToRun);
		}

		/// <summary> 
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.timer = new System.Timers.Timer();
			this.performanceCounter = new System.Diagnostics.PerformanceCounter();
			((System.ComponentModel.ISupportInitialize)(this.timer)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.performanceCounter)).BeginInit();
			// 
			// timer
			// 
			this.timer.Elapsed += new System.Timers.ElapsedEventHandler(this.OnTimer);
			// 
			// performanceCounter
			// 
			this.performanceCounter.CategoryName = "Witaj wiecie";
			this.performanceCounter.CounterName = "Liczba";
			this.performanceCounter.ReadOnly = false;
			// 
			// HelloWorldServiceClass
			// 
			this.ServiceName = "HelloWorldService";
			((System.ComponentModel.ISupportInitialize)(this.timer)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.performanceCounter)).EndInit();

		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Uruchomienie wszystkich elementw, dziki czemu usuga moe rozpocz prac.
		/// </summary>
		protected override void OnStart(string[] args)
		{
			timer.Enabled = true;
		}
 
		/// <summary>
		/// Stop this service.
		/// </summary>
		protected override void OnStop()
		{
			timer.Enabled = false;
		}

		private void OnTimer(object sender, System.Timers.ElapsedEventArgs e)
		{
			performanceCounter.Increment();
		}
	}
}
